//
//  DHDMXUtils.h
//  DHDMX
//
//  Created by Douglas Heriot on 11/04/12.
//  Copyright (c) 2012 Douglas Heriot Design. All rights reserved.
//

#ifndef DHDMX_DHDMXUtils_h
#define DHDMX_DHDMXUtils_h

#import <Foundation/Foundation.h>
#import <mach/mach_time.h>
#import <netinet/in.h>

extern mach_timebase_info_data_t DHDMXMachTimebaseInfo;
extern dispatch_once_t DHDMXMachTimebaseInfoOnce;

static uint64_t DHDMXAbsoluteToNano(uint64_t absoluteTime);
static uint64_t DHDMXNanoToAbsolute(uint64_t nanoseconds);

static inline NSUInteger DHDMXAddressDataHash(NSData *address);
static inline NSUInteger DHDMXAddressDataHashExcludingPort(NSData *address);
static inline BOOL DHDMXAddressDataIsEqual(__unsafe_unretained NSData *address1, __unsafe_unretained NSData *address2);
static inline BOOL DHDMXAddressDataIsEqualExcludingPort(__unsafe_unretained NSData *address1, __unsafe_unretained NSData *address2);




static inline uint64_t DHDMXAbsoluteToNano(uint64_t absoluteTime)
{
	dispatch_once(&DHDMXMachTimebaseInfoOnce, ^{
		mach_timebase_info(&DHDMXMachTimebaseInfo);
	});
	
	// “Do the maths. We hope that the multiplication doesn't 
    // overflow; the price you pay for working in fixed point.”
	
	return absoluteTime * DHDMXMachTimebaseInfo.numer / DHDMXMachTimebaseInfo.denom;
}

static inline uint64_t DHDMXNanoToAbsolute(uint64_t nanoseconds)
{
	dispatch_once(&DHDMXMachTimebaseInfoOnce, ^{
		mach_timebase_info(&DHDMXMachTimebaseInfo);
	});
	
	return nanoseconds * DHDMXMachTimebaseInfo.denom / DHDMXMachTimebaseInfo.numer;
}





static inline NSUInteger DHDMXAddressDataHash(NSData *address)
{
	NSUInteger hash = 0;
	const struct sockaddr_in *addr = address.bytes;
	
	// XOR only the important bits
	hash = addr->sin_addr.s_addr ^ addr->sin_family ^ (addr->sin_port << 16);
	return hash;
}

static inline NSUInteger DHDMXAddressDataHashExcludingPort(NSData *address)
{
	NSUInteger hash = 0;
	const struct sockaddr_in *addr = address.bytes;
	
	// XOR only the important bits
	hash = addr->sin_addr.s_addr ^ addr->sin_family;
	return hash;
}

static inline BOOL DHDMXAddressDataIsEqual(__unsafe_unretained NSData *address1, __unsafe_unretained NSData *address2)
{
	const struct sockaddr_in *addr1 = address1.bytes;
	const struct sockaddr_in *addr2 = address2.bytes;
	
	return (addr1->sin_port == addr2->sin_port &&
			addr1->sin_family == addr2->sin_family &&
			addr1->sin_addr.s_addr == addr2->sin_addr.s_addr);
}

static inline BOOL DHDMXAddressDataIsEqualExcludingPort(__unsafe_unretained NSData *address1, __unsafe_unretained NSData *address2)
{
	const struct sockaddr_in *addr1 = address1.bytes;
	const struct sockaddr_in *addr2 = address2.bytes;
	
	return (addr1->sin_family == addr2->sin_family &&
			addr1->sin_addr.s_addr == addr2->sin_addr.s_addr);
}


#endif
